﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace North_America
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Metoda GetFileName() pobiera od użytkownika
        // nazwę pliku i przypisuje ją zmiennej przekazanej 
        // jako argument. 
        private void GetFileName(out string selectedFile)
        { 
            if (openFile.ShowDialog() == DialogResult.OK) 
            { 
                selectedFile = openFile.FileName; 
            } 
            else 
            { 
                selectedFile = ""; 
            }
        }

        // Metoda GetCountries() akceptuje argument w postaci 
        // nazwy pliku. Otwiera wskazany plik i wyświetla 
        // jego zawartość w kontrolce countriesListBox. 
        private void GetCountries(string filename)
        { 
            try 
            { 
                // Zadeklarowanie zmiennej przechowującej nazwę kraju. 
                string countryName; 
                
                // Zadeklarowanie zmiennej typu StringReader. 
                StreamReader inputFile; 

                // Otworzenie pliku i pobranie obiektu StreamReader. 
                inputFile = File.OpenText(filename); 

                // Usunięcie całej zawartości kontrolki ListBox. 
                countriesListBox.Items.Clear(); 

                // Odczytanie zawartości pliku. 
                while (!inputFile.EndOfStream) 
                { 
                    // Pobranie nazwy kraju. 
                    countryName = inputFile.ReadLine(); 

                    // Dodanie nazwy kraju do kontrolki ListBox. 
                    countriesListBox.Items.Add(countryName);  
                } 

                // Zamknięcie pliku. 
                inputFile.Close(); 
            } 
            catch (Exception ex) 
            { 
                // Wyświetlenie komunikatu błędu. 
                MessageBox.Show(ex.Message); 
            } 
        }

        private void getCountriesButton_Click(object sender, EventArgs e)
        {
            string filename;    // Zmienna przechowuje nazwę pliku. 
            
            // Pobranie od użytkownika nazwy pliku. 
            GetFileName(out filename);
            
            // Pobranie listy krajów z pliku. 
            GetCountries(filename);
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
